<?php
// Exit if accessed directly
if( !defined('ABSPATH') ) exit;

/**
 * Public Pages Class
 *
 * Handles all the different features and functions
 * for the front end pages.
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
class EDD_Slg_Public {

    public $render, $model, $socialfacebook, $socialgoogle, $sociallinkedin, $socialtwitter,
            $socialfoursquare, $socialyahoo, $socialwindowslive, $socialvk,
            $socialamazon, $socialpaypal, $socialapple;

    public function __construct() {

        global $edd_slg_render, $edd_slg_model, $edd_slg_social_facebook, $edd_slg_social_linkedin, $edd_slg_social_twitter, $edd_slg_social_yahoo, $edd_slg_social_foursquare,
        $edd_slg_social_windowslive, $edd_slg_social_vk, $edd_slg_social_amazon, $edd_slg_social_paypal, $edd_slg_social_apple;

        $this->render = $edd_slg_render;
        $this->model = $edd_slg_model;

        //social class objects
        $this->socialfacebook = $edd_slg_social_facebook;
        $this->sociallinkedin = $edd_slg_social_linkedin;
        $this->socialtwitter = $edd_slg_social_twitter;
        $this->socialyahoo = $edd_slg_social_yahoo;
        $this->socialfoursquare = $edd_slg_social_foursquare;
        $this->socialwindowslive = $edd_slg_social_windowslive;
        $this->socialvk = $edd_slg_social_vk;
        $this->socialamazon = $edd_slg_social_amazon;
        $this->socialpaypal = $edd_slg_social_paypal;
        $this->socialapple = $edd_slg_social_apple;
    }

    /**
     * AJAX Call
     * 
     * Handles to Call ajax for register user
     * 
     * @package Easy Digital Downloads - Social Login
     * @since 1.0.0
     */
    public function edd_slg_social_login() {

        global $edd_options;
        if( isset($_REQUEST['eddslg']) && $_REQUEST['eddslg'] == 'apple' ) {
            $type = 'apple';
        } else {
            $type = isset($_POST['type']) ? $this->model->edd_slg_escape_slashes_deep($_POST['type']) : '';
        }

        $result = array();
        $data = array();
        $usercreated = 0;

        //created user who will connect via facebook
        if( $type == 'facebook' ) {

            $userid = $this->socialfacebook->edd_slg_get_fb_user();

            //if user id is null then return
            if( empty($userid) ) return;

            $userdata = $this->socialfacebook->edd_slg_get_fb_userdata( $userid );

            //check permission data user given to application
            $permData = $this->socialfacebook->edd_slg_check_fb_app_permission( 'publish_stream' );

            //if user not give the permission to api and user type is facebook then it will redirected
            if( empty($permData) ) {
                
                $result['redirect'] = '1';

                echo json_encode( $result );
                //do exit to get proper result
                exit;
            }

            //check facebook user data is not empty or check social identifire for register without email
            if( !empty($userdata) && isset($userdata['email']) || isset($userdata['id']) ) {
                $data = $this->model->edd_slg_get_user_common_social_data( $userdata, $type );
            }
        } elseif( $type == 'googleplus' ) {
            
            if(isset($_POST["gp_userdata"])) { 

                $client = new Google_Client(['client_id' => $edd_options['edd_slg_gp_client_id']]);  

                $id_token = $_POST["gp_userdata"];               
                
                $payload = $client->verifyIdToken($id_token); 

                $data_google["given_name"] = $payload['given_name'];
                $data_google["family_name"] = $payload['family_name'];
                $data_google["name"] = $payload['name'];
                $data_google["email"] = $payload['email'];
                $data_google["id"] = $payload['sub'];
                $data_google["img_url"] = $payload['picture'];
                $_POST["gp_userdata"] = $data_google;
            }

            if(isset($_POST["gp_userdata"]) && !empty($_POST["gp_userdata"])){
                $gp_userdata = $_POST["gp_userdata"];
                if( !empty($gp_userdata) ) {
                    $data = $this->model->edd_slg_get_user_common_social_data( $gp_userdata, $type );
                }
            }
        } elseif( $type == 'linkedin' ) {

            $li_userdata = $this->sociallinkedin->edd_slg_get_linkedin_user_data();
            if( !empty($li_userdata['emailAddress']) ) {
                $data = $this->model->edd_slg_get_user_common_social_data( $li_userdata, $type );
            }
        } elseif( $type == 'yahoo' ) {
            
            $yh_userdata = $this->socialyahoo->edd_slg_get_yahoo_user_data();
            if( !empty($yh_userdata) ) {
                if( !empty($yh_userdata['email']) ) {
                    $data = $this->model->edd_slg_get_user_common_social_data( $yh_userdata, $type );
                }
            }
                
        } elseif( $type == 'foursquare' ) { //check type is four squere

            $fs_userdata = $this->socialfoursquare->edd_slg_get_foursquare_user_data();
            if( !empty($fs_userdata) ) {
                $data = $this->model->edd_slg_get_user_common_social_data( $fs_userdata, $type );
            }

        } elseif( $type == 'windowslive' ) { //check type is four squere

            $wl_userdata = $this->socialwindowslive->edd_slg_get_windowslive_user_data();

            //check windowslive user data is not empty
            if( !empty($wl_userdata) ) {
                $wlemail = isset( $wl_userdata->emails->preferred ) ? $wl_userdata->emails->preferred : $wl_userdata->emails->account;
                $wl_userdata->wlemail = $wlemail;
                $data = $this->model->edd_slg_get_user_common_social_data( $wl_userdata, $type );
            }

        } elseif( $type == 'vk' ) { //check type is vk

            $vk_userdata = $this->socialvk->edd_slg_get_vk_user_data();
            if( !empty($vk_userdata) ) {
                $data = $this->model->edd_slg_get_user_common_social_data( $vk_userdata, $type );
            }

        } elseif( $type == 'twitter' ) { //check type is twitter

            $tw_userdata = $this->socialtwitter->edd_slg_get_twitter_user_data();
            //check user id is set or not for twitter
            if( !empty($tw_userdata) && isset($tw_userdata['id']) && !empty($tw_userdata['id']) ) {
                $data = $this->model->edd_slg_get_user_common_social_data( $tw_userdata, $type );
            }
        } else if ($type == 'amazon') { //check type is amazon
            $amazon_userdata = $this->socialamazon->edd_slg_get_amazon_user_data();
            if (!empty($amazon_userdata) && isset($amazon_userdata->user_id) && !empty($amazon_userdata->user_id)) {//check user id is set or not for amazon
                $data = $this->model->edd_slg_get_user_common_social_data($amazon_userdata, $type);
            }
        } else if ($type == 'paypal') { //check type is paypal
            $paypal_userdata = $this->socialpaypal->edd_slg_get_paypal_user_data();
            if (!empty($paypal_userdata) && isset($paypal_userdata->user_id) && !empty($paypal_userdata->user_id)) {//check user id is set or not for paypal
                $data = $this->model->edd_slg_get_user_common_social_data($paypal_userdata, $type);
            }
        } else if ($type == 'apple') {

            $apple_userdata = $this->socialapple->edd_slg_get_apple_user_data();
            if (!empty($apple_userdata->email)) {
                $data = $this->model->edd_slg_get_user_common_social_data($apple_userdata, $type);
            }
        }

        if (!empty($data)) { //If user data is not empty
            $result = $this->edd_slg_process_profile($data);

            if( ( !empty($result) ) && ( $result != 'true' || $result != 1 ) ){
                $result = 'restrict';
                echo $result;
                exit;
            }
        }

        if (!is_user_logged_in()) { //do action when user successfully created
            do_action('edd_slg_social_create_user_after', $type, $usercreated);
        }

        if(isset($_REQUEST['eddslg']) && $_REQUEST['eddslg'] == 'apple'){
            $redirect_url = !empty($edd_options['edd_slg_redirect_url']) ? $edd_options['edd_slg_redirect_url'] : home_url();
                    // set no cache param
            $redirect_url = edd_slg_add_no_cache_param($redirect_url);
            wp_redirect($redirect_url);
        }else{
            echo json_encode($result);
        }
        //do exit to get proper result

        // Check if user register disable
        if( ! get_option( 'users_can_register' ) && !is_user_logged_in() && ( $result != 'true' || $result != 1 ) ) { // Check user register option enable
            $result = 'restrict';
            echo $result;
        }

        exit;
    }

    /**
     * Process Profile
     * 
     * Handles to process social profile
     * 
     * @package Easy Digital Download - Social Login
     * @since 1.5.6
     */
    public function edd_slg_process_profile($data = array()) {

        global $wpdb;

        $user = null;
        $new_customer = false;
        $found_via = null;

        $message = edd_slg_messages();

        if (!empty($data) && !empty($data['type'])) {

             
            //social provider type
            $type = $data['type'];
            $identifier = isset($data['id']) ? esc_attr($data['id']) : '';
            $user_id = '';

            if(!empty($identifier)){

                // First, try to identify user based on the social identifier
              $user_id = $wpdb->get_var($wpdb->prepare('SELECT user_id FROM ' . $wpdb->usermeta . ' WHERE ( meta_key = "%s" AND meta_value = "%s" || meta_key = "%s" AND meta_value = "%s" )', 'edd_slg_social_' . $type . '_identifier', $identifier, 'edd_slg_social_identifier', $identifier));

            }
            

            if ($user_id) {
                $user = get_user_by('id', $user_id);
                $found_via = 'social_identifier';
            }

            // Fall back to email - user may already have an account with the same email as in their social profile
            if (!$user && !empty($data['email'])) {
                $user = get_user_by('email', $data['email']);
                $found_via = 'email';
            }

            if (is_user_logged_in()) { // If a user is already logged in
                // check that the logged in user and found user are the same.
                // This happens when user is linking a new social profile to their account.
                if ($user && get_current_user_id() !== $user->ID) {

                    if ($found_via == 'social_identifier') {
                        $already_linked_error = isset($message['already_linked_error']) ? $message['already_linked_error'] : '';

                        return edd_set_error('edd_slg_account_already_linked', $already_linked_error);
                    } else {

                        $account_exist_error = isset($message['account_exist_error']) ? $message['account_exist_error'] : '';
                        return edd_set_error('edd_slg_account_already_exist', $account_exist_error);
                    }
                }

                // If the social profile is not linked to any user accounts,
                // use the currently logged in user as the customer
                if (!$user) {
                    $user = get_user_by('id', get_current_user_id());
                }
            }

            if (!$user) { // If no user was found, create one
                if( get_option( 'users_can_register' ) ) { // Check user register option enable
                    $user_id = $this->edd_slg_add_user($data);
                    $user = get_user_by('id', $user_id);

                    // indicate that a new user was created
                    $new_customer = true;
                }else{
                    return 'New user registrations are disabled on this website. Please contact admin.';
                }
            }

            // Update customer's WP user profile and billing details
            $this->edd_slg_update_customer_profile($user->ID, $data, $new_customer);

            if ($type == 'facebook') {
                EddSocialLoginPersistentAnonymous::delete('facebook_at');
                EddSocialLoginPersistentAnonymous::delete('facebook_display');
            }
            if (!is_user_logged_in()) { // Log user in or add account linked notice for a logged in user
                wp_set_auth_cookie($user->ID);

                //update last login with social account
                edd_slg_update_social_last_login_timestamp($user->ID, $type);

                do_action('edd_slg_login_user_authenticated', $user->ID, $type);

                return true;
            } else {

                $_SESSION['edd_slg_linked_notice'] = sprintf(esc_html__('Your %s account is now linked to your account.', 'eddslg'), $type);
            }
        }
    }

    /**
     * Update customer's social profiles
     * 
     * Handles to update customer's social profiles
     * 
     * @package Easy Digital Doenload - Social Login
     * @since 1.5.6
     */
    public function edd_slg_update_customer_profile($wp_id = '', $wp_user_data = array(), $new_customer = false) {

        if ($wp_id > 0 && !empty($wp_user_data['type'])) { //check wordpress user id is greater then zero
            //type of social account
            $type = $wp_user_data['type'];
            $user_id = !empty($wp_user_data['id']) ? $wp_user_data['id'] : '';

            if ($new_customer) { //If new customer is created
                //social data update
                update_user_meta($wp_id, 'edd_slg_social_data', $wp_user_data['all']);
                update_user_meta($wp_id, 'edd_slg_social_identifier',$user_id);
                update_user_meta($wp_id, 'edd_slg_social_user_connect_via', $wp_user_data['type']);

                // Updating billing information
                update_user_meta($wp_id, 'billing_first_name', $wp_user_data['first_name']);
                update_user_meta($wp_id, 'billing_last_name', $wp_user_data['last_name']);

                // Updating shipping information
                update_user_meta($wp_id, 'shipping_first_name', $wp_user_data['first_name']);
                update_user_meta($wp_id, 'shipping_last_name', $wp_user_data['last_name']);

                $wpuserdetails = array(
                    'ID' => $wp_id,
                    'user_url' => $wp_user_data['link'],
                    'first_name' => $wp_user_data['first_name'],
                    'last_name' => $wp_user_data['last_name'],
                    'nickname' => $wp_user_data['name'],
                    'user_url' => $wp_user_data['link'],
                    'display_name' => $wp_user_data['name']
                );

                wp_update_user($wpuserdetails);
            } else {

                $primary = get_user_meta($wp_id, 'edd_slg_social_user_connect_via', true);
                $secondary = get_user_meta($wp_id, 'edd_slg_social_' . $type . '_identifier', true);

                if ($primary != $type && $secondary != $type) {

                    update_user_meta($wp_id, 'edd_slg_social_' . $type . '_data', $wp_user_data['all']);
                    update_user_meta($wp_id, 'edd_slg_social_' . $type . '_identifier', $wp_user_data['id']);
                }
            }
        }
    }

    /**
     * Add User
     * 
     * Handles to Add user to wordpress database
     * 
     * @package Easy Digital Downloads - Social Login
     * @since 1.0.0
     */
    public function edd_slg_add_user($userdata) {

        // register a new WordPress user
        $wp_user_data = array();
        $wp_user_data['name'] = $userdata['name'];
        $wp_user_data['first_name'] = $userdata['first_name'];
        $wp_user_data['last_name'] = $userdata['last_name'];
        $wp_user_data['email'] = (!empty($userdata['email']) ) ? $userdata['email'] : '';

        // added for vk.com
        $wp_user_data['id'] = isset($userdata['id']) ? $userdata['id'] : '';  
        $wp_user_data['type'] = isset($userdata['type']) ? $userdata['type'] : '';

        $wp_id = $this->model->edd_slg_add_wp_user($wp_user_data);

        if ($wp_id > 0) { //check wordpress user id is greater then zero
            update_user_meta($wp_id, 'edd_slg_social_data', $userdata['all']);
            update_user_meta($wp_id, 'edd_slg_social_user_connect_via', $userdata['type']);
            update_user_meta($wp_id, 'edd_slg_social_identifier', $wp_user_data['id']);

            $wpuserdetails = array(
                'ID' => $wp_id,
                'user_url' => $userdata['link'],
                'first_name' => $userdata['first_name'],
                'last_name' => $userdata['last_name'],
                'nickname' => $userdata['name'],
                'user_url' => $userdata['link'],
                'display_name' => $userdata['name']
            );

            wp_update_user($wpuserdetails);

            //make user logged in
            wp_set_auth_cookie($wp_id, false);
            return $wp_id;
        }
        return false;
    }

    /**
     * Load Login Page For Social
     * 
     * Handles to load login page for social
     * when no email address found
     * 
     * @package Easy Digital Downloads - Social Login
     * @since 1.0.0
     */
    public function edd_slg_social_login_redirect() {

        global $edd_options;

        $socialtype = isset($_GET['eddslgnetwork']) ? $_GET['eddslgnetwork'] : '';

        //get all social networks
        $allsocialtypes = edd_slg_social_networks();

        if (!is_user_logged_in() && isset($_GET['edd_slg_social_login']) && !empty($socialtype) && array_key_exists($socialtype, $allsocialtypes)) {

            // get redirect url from shortcode 
            $stcd_redirect_url = EDD()->session->get('edd_slg_stcd_redirect_url');

            //check button clicked from widget then redirect to widget page url
            if (isset($_GET['container']) && $_GET['container'] == 'widget') {

                // get redirect url from widget 
                $stcd_redirect_url = EDD()->session->get('edd_slg_stcd_redirect_url_widget');
            }

            $redirect_url = !empty($stcd_redirect_url) ? $stcd_redirect_url : site_url();

            $redirect_url = edd_slg_add_no_cache_param($redirect_url);

            $data = array();

            //wordpress error class		
            $errors = new WP_Error();

            switch ($socialtype) {

                case 'twitter' :
                    //get twitter user data
                    $tw_userdata = $this->socialtwitter->edd_slg_get_twitter_user_data();

                    //check user id is set or not for twitter
                    if (!empty($tw_userdata) && isset($tw_userdata['id']) && !empty($tw_userdata['id'])) {

                        $data['first_name'] = $tw_userdata['name'];
                        $data['last_name'] = '';
                        $data['name'] = $tw_userdata['screen_name']; //display name of user
                        $data['type'] = 'twitter';
                        $data['all'] = $tw_userdata;
                        $data['link'] = 'https://twitter.com/' . $tw_userdata['screen_name'];
                        $data['id'] = $tw_userdata['id'];
                        $data['email'] = !empty($tw_userdata['email']) ? $tw_userdata['email'] : '';
                    }
                    break;
            }

            //if cart is empty or user is not logged in social media
            //and accessing the url then send back user to checkout page
            if (!isset($data['id']) || empty($data['id'])) {


                if (isset($_SESSION['edd']['edd_slg_stcd_redirect_url_widget'])) {
                    unset($_SESSION['edd']['edd_slg_stcd_redirect_url_widget']);
                }
                if (isset($_SESSION['edd']['edd_slg_stcd_redirect_url'])) {
                    unset($_SESSION['edd']['edd_slg_stcd_redirect_url']);
                }
                wp_redirect($redirect_url);
                exit;
            }

            //when user will click submit button of custom login
            //check user clicks submit button of registration page and get parameter should be valid param
            if (( isset($_POST['edd-slg-submit']) && !empty($_POST['edd-slg-submit']) && $_POST['edd-slg-submit'] == esc_html__('Register', 'eddslg'))) {

                $loginurl = wp_login_url();

                if (isset($_POST['edd_slg_social_email'])) { //check email is set or not
                    $socialemail = $_POST['edd_slg_social_email'];

                    if (empty($socialemail)) { //if email is empty
                        $errors->add('empty_email', '<strong>' . esc_html__('ERROR', 'eddslg') . ' :</strong> ' . esc_html__('Enter your email address.', 'eddslg'));
                    } elseif (!is_email($socialemail)) { //if email is not valid
                        $errors->add('invalid_email', '<strong>' . esc_html__('ERROR', 'eddslg') . ' :</strong> ' . esc_html__('The email address did not validate.', 'eddslg'));
                        $socialemail = '';
                    } elseif (email_exists($socialemail)) {//if email is exist or not
                        $errors->add('email_exists', '<strong>' . esc_html__('ERROR', 'eddslg') . ' :</strong> ' . esc_html__('Email already exists, If you have an account login first.', 'eddslg'));
                    }

                    if ($errors->get_error_code() == '') { //
                        if (!empty($data)) { //check user data is not empty
                            $data['email'] = $socialemail;

                            //create user
                            $usercreated = $this->edd_slg_add_user($data);

                            if (isset($_SESSION['edd']['edd_slg_stcd_redirect_url_widget'])) {
                                unset($_SESSION['edd']['edd_slg_stcd_redirect_url_widget']);
                            }
                            if (isset($_SESSION['edd']['edd_slg_stcd_redirect_url'])) {
                                unset($_SESSION['edd']['edd_slg_stcd_redirect_url']);
                            }
                            wp_redirect($redirect_url);
                            exit;
                        }
                    }
                }
            }

            //redirect user to custom registration form
            if (isset($_GET['edd_slg_social_login']) && !empty($_GET['edd_slg_social_login']) && empty($tw_userdata['email'])) {

                //login call back url after registration
                $socialemail = isset($_POST['edd_slg_social_email']) ? $_POST['edd_slg_social_email'] : '';

                //check the user who is going to connect with site
                //it is alreay exist with same data or not 
                //if user is exist then simply make that user logged in
                $metaquery = array(
                    array(
                        'key' => 'edd_slg_social_user_connect_via',
                        'value' => $data['type']
                    ),
                    array(
                        'key' => 'edd_slg_social_identifier',
                        'value' => $data['id']
                    )
                );

                $getusers = get_users(array('meta_query' => $metaquery));
                $wpuser = array_shift($getusers); //getting users 
                //check user is exist or not conected with same metabox
                if (!empty($wpuser)) {

                    //make user logged in
                    wp_set_auth_cookie($wpuser->ID, false);

                    if (isset($_SESSION['edd']['edd_slg_stcd_redirect_url_widget'])) {
                        unset($_SESSION['edd']['edd_slg_stcd_redirect_url_widget']);
                    }
                    if (isset($_SESSION['edd']['edd_slg_stcd_redirect_url'])) {
                        unset($_SESSION['edd']['edd_slg_stcd_redirect_url']);
                    }
                    wp_redirect($redirect_url);
                    exit;
                } else {

                    //if user is not exist then show register user form

                    login_header(esc_html__('Registration Form', 'eddslg'), '<p class="message register">' . esc_html__('Please enter your email address to complete registration.', 'eddslg') . '</p>', $errors);
                    ?>
                    <form name="registerform" id="registerform" action="" method="post">
                        <p>
                            <label for="wcsl_email"><?php esc_html_e('E-mail', 'eddslg'); ?><br />
                                <input type="text" name="edd_slg_social_email" id="edd_slg_social_email" class="input" value="<?php echo $socialemail ?>" size="25" tabindex="20" /></label>
                        </p>
                        <p id="reg_passmail">
                    <?php esc_html_e('Username and Password will be sent to your email.', 'eddslg'); ?>
                        </p>
                        <br class="clear" />
                        <p class="submit"><input type="submit" name="edd-slg-submit" id="edd-slg-submit" class="button-primary" value="<?php _e('Register', 'eddslg'); ?>" tabindex="100" /></p>
                    </form>
                    <?php
                    login_footer('user_login');
                    exit;
                }
            } elseif (!empty($tw_userdata['email']) && isset($_GET['edd_slg_social_login']) && !empty($_GET['edd_slg_social_login'])) {

                $this->edd_slg_process_profile($data);

                if (isset($_SESSION['edd']['edd_slg_stcd_redirect_url_widget'])) {
                    unset($_SESSION['edd']['edd_slg_stcd_redirect_url_widget']);
                }
                if (isset($_SESSION['edd']['edd_slg_stcd_redirect_url'])) {
                    unset($_SESSION['edd']['edd_slg_stcd_redirect_url']);
                }

                wp_redirect($redirect_url);
                exit;
            }
        }
    }

    /**
     * Handles to change avatar image if user is connected via social service
     * 
     * @package Easy Digital Downloads - Social Login
     * @since 1.4
     */
    function edd_slg_get_avatar($avatar, $id_or_email, $size, $default, $alt) {

        $user_id = false;

        if (is_numeric($id_or_email)) { // If user id is there
            $user_id = $id_or_email;
        } elseif (is_object($id_or_email)) { // If data is from comment then take user id
            if (!empty($id_or_email->user_id)) {
                $user_id = $id_or_email->user_id;
            }
        } else {
            $user = get_user_by('email', $id_or_email);
            $user_id = isset($user->ID) ? $user->ID : '';
        }

        // Getting profile pic
        $avatar_pic = $this->model->edd_slg_get_user_profile_pic($user_id);

        if (!empty($avatar_pic)) {
            $avatar = '<img width="' . $size . '" height="' . $size . '" class="avatar avatar-' . $size . '" src="' . esc_url($avatar_pic) . '" alt="" />';
        }

        return $avatar;
    }

    /**
     * AJAX Call
     * 
     * Handles to Call ajax for unlink  user profile
     * 
     * @package Easy Digital Downloads - Social Login
     * @since 1.5.6
     */
    public function edd_slg_social_unlink_profile() {

        //get provider
        $provider = isset($_POST['provider']) ? $_POST['provider'] : '';

        $edd_slg_profile_data = '';
        $result = array();
        $data = '';

        if (is_user_logged_in()) {

            // Get current user login id
            $user_id = get_current_user_id();

            if ($user_id) { //If user id exist
                if (!empty($provider)) {

                    delete_user_meta($user_id, 'edd_slg_social_' . $provider . '_data');
                    delete_user_meta($user_id, 'edd_slg_social_' . $provider . '_identifier');

                    delete_user_meta($user_id, 'edd_slg_social_' . $provider . '_login_timestamp');
                    delete_user_meta($user_id, 'edd_slg_social_' . $provider . '_login_timestamp_gmt');
                } else { // unlink primary account from version 2.1.1
                    delete_user_meta($user_id, 'edd_slg_social_data');
                    delete_user_meta($user_id, 'edd_slg_social_identifier');
                    delete_user_meta($user_id, 'edd_slg_social_user_connect_via');
                }

                ob_start();
                $this->render->edd_slg_social_profile();
                $data = ob_get_clean();

                $messages = edd_slg_messages();
                $account_unlinked_notice = $messages['account_unlinked_notice'] ? $messages['account_unlinked_notice'] : '';

                // display notice for unlink account				
                $_SESSION['edd_slg_unlinked_notice'] = sprintf($account_unlinked_notice, ucfirst($_POST['provider']));
                $result = array(
                    'success' => 1,
                    'data' => $data
                );
            }
        }

        echo json_encode($result);
        exit;
    }

    /**
     * Allow Social login buttons on login page of WordPress
     * 
     * Handle login page Social login buttons based on settings
     * 
     * @package Easy Digital Downloads - Social Login
     * @since 1.0.1
     */
    public function edd_slg_social_login_buttons_on_wp_login() {

        //add social login buttons on wordpress login page
        add_action('login_footer', array($this->render, 'edd_slg_social_login_buttons_on_login'));
    }

    /**
     * Allow Social login buttons on register page of WordPress
     * 
     * Handle register page Social login buttons based on settings
     * 
     * @package Easy Digital Downloads - Social Login
     * @since 1.0.1
     */
    public function edd_slg_social_login_buttons_on_wp_register() {

        //add social login buttons on wordpress login page
        add_action('login_footer', array($this->render, 'edd_slg_social_login_buttons_on_login'));
    }

    /**
     * Filter to display social login button on FES login and registration page  
     * 
     * @package Easy Digital Downloads - Social Login
     * @since 2.1.2
     */
    public function edd_slg_social_login_buttons_on_fes_form($output) {

        ob_start();
        $this->render->edd_slg_social_login_buttons_on_login();
        $social_buttons = ob_get_clean();

        return $output . $social_buttons;
    }

    /**
     * Process Facebook data on page load
     * 
     * This function will Save the data of facebook in database
     * 
     * @package Easy Digital Downloads - Social Login
     * @since Version 2.1.4
     */
    public function edd_slg_process_facebook_data() {

        global $edd_options, $wpdb;

        if (EddSocialLoginPersistentAnonymous::get('facebook_at')) {
            $type = "facebook";
            $usercreated = 0;
            $userdata = $this->socialfacebook->edd_slg_live_connect_user_fb_profile();

            if ($userdata) {
                //check facebook user data is not empty or check social identifire for register without email
                if (!empty($userdata) && isset($userdata['email']) || isset($userdata['id'])) { //check isset user email from facebook 
                    $data = $this->model->edd_slg_get_user_common_social_data($userdata, $type);
                }

                if (!empty($data)) { //If user data is not empty
                    $result = $this->edd_slg_process_profile($data);
                }

                if (!is_user_logged_in()) { //do action when user successfully created
                    do_action('edd_slg_social_create_user_after', $type, $usercreated);
                }

                $current_page_url = (!empty($_SESSION['edd_slg_fb_redirect_url']) ) ? $_SESSION['edd_slg_fb_redirect_url'] : site_url();

                $redirect_url = !empty($edd_options['edd_slg_redirect_url']) ? $edd_options['edd_slg_redirect_url'] : $current_page_url;

                $redirect_url = edd_slg_add_no_cache_param($redirect_url);

                wp_redirect($redirect_url);
                exit;
            }
        }
    }

    /**
     * Handle to load public script for checkout page
     * 
     * 
     * @package Easy Digital Downloads - Social Login
     * @since Version 2.2.7
     */
    public function edd_slg_social_load_script() {

        //enqueue social front script
        wp_enqueue_script('edd-slg-public-script');
    }

    public function edd_slg_social_login_google_on_ajax_load_script() {

        global $edd_options;

        $google_client_id = ( isset($edd_options['edd_slg_gp_client_id']) && !empty($edd_options['edd_slg_gp_client_id']) ) ? $edd_options['edd_slg_gp_client_id'] : '';

        $is_google_enabled = (isset($edd_options['edd_slg_enable_googleplus']) && $edd_options['edd_slg_enable_googleplus'] == '1' ) ? '1' : '';

        if (!empty($is_google_enabled) && isset($edd_options['edd_slg_enable_login_options']['edd_checkout']) && !empty($edd_options['edd_slg_enable_login_options']['edd_checkout'])) {
            ?>
            <script type="text/javascript">
                jQuery(document).ready(function ($) {

                    if ($(".edd-slg-social-login-googleplus").length > 0) {

                        var auth2;

                        gapi.load('auth2', function () {

                            auth2 = gapi.auth2.init({
                                client_id: "<?php echo $google_client_id; ?>",
                                cookiepolicy: 'single_host_origin',
                            });

                            jQuery(document).find('.edd-slg-social-login-googleplus').each(function (i, j) {
                                edd_slg_google_signin_test(j);
                            });

                        });


                        function edd_slg_google_signin_test(element) {

                            var object = $(element);

                            auth2.attachClickHandler(element, {},
                                    function (googleUser) {

                                        var profile = googleUser.getBasicProfile();

                                        var gp_userdata = {
                                            given_name: profile.getGivenName(),
                                            family_name: profile.getFamilyName(),
                                            name: profile.getName(),
                                            email: profile.getEmail(),
                                            id: profile.getId(),
                                            img_url: profile.getImageUrl(),
                                        };

                                        var edd_slg_post_data = {
                                            action: 'edd_slg_social_login',
                                            type: 'googleplus',
                                            gp_userdata: gp_userdata,

                                        };

                                        $.ajax({
                                            url: EDDSlg.ajaxurl,
                                            type: 'post',
                                            data: edd_slg_post_data,
                                            success: function (edd_slg_google_ajax_response) {
                                                if (edd_slg_google_ajax_response) {
                                                    edd_slg_social_connect('googleplus', object);
                                                }
                                            }
                                        });

                                    }, function (error) {
                                if (error.error == "popup_closed_by_user") {


                                    return false;
                                } else {
                                    errorel.show();
                                    errorel.html(error.error);
                                    return false;
                                }

                            });
                        }
                    }
                });
            </script> 
            <?php
        }
    }

    /**
     * Adding Hooks
     *
     * Adding proper hoocks for the public pages.
     *
     * @package Easy Digital Downloads - Social Login
     * @since 1.0.0
     */
    public function add_hooks() {

        global $edd_options;

        //check is there any social media is enable or not
        if (edd_slg_check_social_enable()) {

            $edd_social_order = get_option( 'edd_social_order' );

            //Initializes Facebook API
            add_action('init', array($this->socialfacebook, 'edd_slg_initialize_facebook'));

            add_action('wp', array($this, 'edd_slg_process_facebook_data'));

            add_action('edd_payment_receipt_before', 'edd_print_errors');


            // add action for linkedin login
            add_action('init', array($this->sociallinkedin, 'edd_slg_initialize_linkedin'));

            // add action for twitter login
            add_action('init', array($this->socialtwitter, 'edd_slg_initialize_twitter'));

            // add action for yahoo login
            add_action('init', array($this->socialyahoo, 'edd_slg_initialize_yahoo'));

            // add action for foursquare login
            add_action('init', array($this->socialfoursquare, 'edd_slg_initialize_foursquare'));

            //add action for windows live login
            add_action('init', array($this->socialwindowslive, 'edd_slg_initialize_windowslive'));

            // add action for vk login
            add_action('init', array($this->socialvk, 'edd_slg_initialize_vk'));


            // add action for amazon login
            add_action('init', array($this->socialamazon, 'edd_slg_initialize_amazon'));

            // add action for paypal login
            add_action('init', array($this->socialpaypal, 'edd_slg_initialize_paypal'));

            // add action for apple login
            add_action('init', array($this->socialapple, 'edd_slg_initialize_apple'));

            //Check if EDD checkout option enabled
            if (!empty($edd_options['edd_slg_enable_login_options']['edd_checkout'])) {

                add_action('edd_after_purchase_form', array($this, 'edd_slg_social_load_script'));


                if ($edd_options['edd_slg_social_btn_position'] == 'top') {

                    if (!isset($edd_options['show_register_form']) || $edd_options['show_register_form'] == 'none') {

                        add_action('edd_checkout_form_top', array($this->render, 'edd_slg_social_login_buttons'));
                    } elseif (isset($edd_options['show_register_form']) && $edd_options['show_register_form'] == 'login') {

                        // above checkout login form
                        add_action('edd_checkout_login_fields_before', array($this->render, 'edd_slg_social_login_buttons'));

                        add_action('edd_checkout_login_fields_before', array($this, 'edd_slg_social_login_google_on_ajax_load_script'), 1);
                    } elseif (isset($edd_options['show_register_form']) && $edd_options['show_register_form'] == 'registration') {

                        // above checkout register form
                        add_action('edd_register_fields_before', array($this->render, 'edd_slg_social_login_buttons'));
                        add_action('edd_register_fields_before', array($this, 'edd_slg_social_login_google_on_ajax_load_script'), 1);
                    } elseif (isset($edd_options['show_register_form']) && $edd_options['show_register_form'] == 'both') {

                        // above both login and register in checkout
                        add_action('edd_checkout_login_fields_before', array($this->render, 'edd_slg_social_login_buttons'));
                        add_action('edd_checkout_login_fields_before', array($this, 'edd_slg_social_login_google_on_ajax_load_script'), 1);

                        add_action('edd_register_fields_before', array($this->render, 'edd_slg_social_login_buttons'));

                        add_action('edd_register_fields_before', array($this, 'edd_slg_social_login_google_on_ajax_load_script'), 1);
                    }
                } else {

                    if (!isset($edd_options['show_register_form']) || $edd_options['show_register_form'] == 'none') {
                        add_action('edd_checkout_form_top', array($this->render, 'edd_slg_social_login_buttons'));
                    } elseif (isset($edd_options['show_register_form']) && $edd_options['show_register_form'] == 'login') {

                        // below checkout login
                        add_action('edd_checkout_login_fields_after', array($this->render, 'edd_slg_social_login_buttons'));
                        add_action('edd_checkout_login_fields_after', array($this, 'edd_slg_social_login_google_on_ajax_load_script'), 1);
                    } elseif (isset($edd_options['show_register_form']) && $edd_options['show_register_form'] == 'registration') {

                        // below checkout registration form
                        add_action('edd_register_fields_after', array($this->render, 'edd_slg_social_login_buttons'));
                        add_action('edd_register_fields_after', array($this, 'edd_slg_social_login_google_on_ajax_load_script'), 1);
                    } elseif (isset($edd_options['show_register_form']) && $edd_options['show_register_form'] == 'both') {

                        // below both checkout login and registration
                        add_action('edd_checkout_login_fields_after', array($this->render, 'edd_slg_social_login_buttons'));
                        add_action('edd_checkout_login_fields_after', array($this, 'edd_slg_social_login_google_on_ajax_load_script'), 1);

                        add_action('edd_register_fields_after', array($this->render, 'edd_slg_social_login_buttons'));
                        add_action('edd_register_fields_after', array($this, 'edd_slg_social_login_google_on_ajax_load_script'), 1);
                    }
                }
            }

            if ($edd_options['edd_slg_social_btn_position'] == 'top') {

                // render login buttons at the top on the myaccount page
                add_action('edd_profile_editor_before', array($this->render, 'edd_slg_myaccount_social_login_buttons'));
            } else {

                // render login buttons at bottom on the myaccount page
                add_action('edd_profile_editor_after', array($this->render, 'edd_slg_myaccount_social_login_buttons'));
            }

            // optional link buttons on thank you page
            add_action('edd_payment_receipt_after_table', array($this->render, 'edd_slg_maybe_render_social_link_buttons'));

            //add action to load login page
            add_action('login_init', array($this, 'edd_slg_social_login_redirect'));

            if( !empty($edd_social_order) ) {
                $priority = 5;

                $edd_social_order = array_unique( $edd_social_order );
                foreach( $edd_social_order as $social ) {

                    // remove instagram if found
                    if( $social == 'instagram' ) continue;

                    add_action('edd_slg_checkout_social_login', array($this->render, 'edd_slg_login_' . $social), $priority);
                    $priority += 5;
                }
            }
        }

        // Filter to change the avatar image
        add_filter('get_avatar', array($this, 'edd_slg_get_avatar'), 10, 5);

        //AJAX Call to Login Via Social Media
        add_action('wp_ajax_edd_slg_social_login', array($this, 'edd_slg_social_login'));
        add_action('wp_ajax_nopriv_edd_slg_social_login', array($this, 'edd_slg_social_login'));

        //AJAX Call to unlink Via Social Media
        add_action('wp_ajax_edd_slg_social_unlink_profile', array($this, 'edd_slg_social_unlink_profile'));
        add_action('wp_ajax_nopriv_edd_slg_social_unlink_profile', array($this, 'edd_slg_social_unlink_profile'));

        //Check if Wordpress login option enabled
        if (!empty($edd_options['edd_slg_enable_login_options']['wp_login'])) {

            //add social login buttons on wordpress login page
            // not check position as this only the hook for login
            add_action('login_form_login', array($this, 'edd_slg_social_login_buttons_on_wp_login'));
        }

        //Check if Wordpress register option enabled
        if (!empty($edd_options['edd_slg_enable_login_options']['wp_register'])) {

            //add social login buttons on wordpress login page
            // not check position as this only the hook for register
            add_action('login_form_register', array($this, 'edd_slg_social_login_buttons_on_wp_register'));
        }

        //Check if EDD login option enabled
        if (!empty($edd_options['edd_slg_enable_login_options']['edd_login'])) {

            if ($edd_options['edd_slg_social_btn_position'] == 'top') {

                //add action to add social login button before edd login form
                add_action('edd_login_fields_before', array($this->render, 'edd_slg_social_login_buttons'));
            } else {

                //add action to add social login button after edd login form
                add_action('edd_login_fields_after', array($this->render, 'edd_slg_social_login_buttons'));
            }
        }

        //Check if EDD register option enabled
        if (!empty($edd_options['edd_slg_enable_login_options']['edd_register'])) {

            if ($edd_options['edd_slg_social_btn_position'] == 'top') {

                //add action to add social login button before edd register form
                add_action('edd_register_form_fields_before', array($this->render, 'edd_slg_social_login_buttons'));
            } else {

                //add action to add social login button after edd register form
                add_action('edd_register_form_fields_after', array($this->render, 'edd_slg_social_login_buttons'));
            }
        }

        //Check if buddypress login option enabled
        if (!empty($edd_options['edd_slg_enable_login_options']['buddypress_login'])) {

            //add social login buttons on BuddyPress login.
            add_action('bp_after_login_widget_loggedout', array($this->render, 'edd_slg_social_login_buttons'));
        }

        //Check if buddypress registration option enabled
        if (!empty($edd_options['edd_slg_enable_login_options']['buddypress_register'])) {

            //add social login buttons on BuddyPress registration.
            add_action('bp_after_register_page', array($this->render, 'edd_slg_social_login_buttons'));
        }

        //Check if bbpress login option enabled
        if (class_exists('bbPress') && !empty($edd_options['edd_slg_enable_login_options']['bbpress_login'])) {

            // remove default wordpress login action hook
            remove_action('login_form_login', array($this, 'edd_slg_social_login_buttons_on_wp_login'));

            //add social login buttons on bbPress login.
            add_action('login_form', array($this->render, 'edd_slg_social_login_buttons_on_login'), 999);
        }

        //Check if bbpress login option enabled
        if (class_exists('bbPress') && !empty($edd_options['edd_slg_enable_login_options']['bbpress_register'])) {

            // remove default wordpress register action hook
            remove_action('login_form_register', array($this, 'edd_slg_social_login_buttons_on_wp_register'));

            //add social login buttons on bbPress registration.
            add_action('register_form', array($this->render, 'edd_slg_social_login_buttons_on_login'), 999);
        }

        //Check if FES plugin is active
        if (class_exists('EDD_Front_End_Submissions')) {

            //Check if FES Registration option enabled
            if (!empty($edd_options['edd_slg_enable_login_options']['edd_slg_fes_register'])) {
                add_filter('fes_render_registration_form_frontend_output_after_fields', array($this, 'edd_slg_social_login_buttons_on_fes_form'), 10, 1);
            }

            //Check if FES Login option enabled
            if (!empty($edd_options['edd_slg_enable_login_options']['edd_slg_fes_login'])) {
                add_filter('fes_render_login_form_frontend_output_after_fields', array($this, 'edd_slg_social_login_buttons_on_fes_form'), 10, 1);
            }
        }

        /**
         * Check if Buttons position is custom hooks
         * Display buttons to the custom hooks added in setting
         */
        $btn_position = !empty($edd_options['edd_slg_social_btn_position']) ? $edd_options['edd_slg_social_btn_position'] : ''; 
        if ($btn_position == 'hook') {
            $custom_hooks = $edd_options['edd_slg_social_btn_hooks'];
            if (!empty($custom_hooks)) {

                foreach ($custom_hooks as $key => $custom_hook) {
                    add_action($custom_hook, array($this->render, 'edd_slg_social_login_buttons_on_login'));
                }
            }
        }
    }

}
